/**
 * Vexus Auto-Initializer
 */

(function() {
    'use strict';
    
    function initVexus() {
        if (typeof VexusCore === 'undefined') {
            setTimeout(initVexus, 100);
            return;
        }
        
        const interceptor = new VexusCore.DOMInterceptor();
        interceptor.init();
        
        setTimeout(() => {
            interceptor.loadCampaignsFromCampaigner().then(() => {
                interceptor.executeCampaignsWithRetry();
            });
        }, 1000);
    }
    
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', initVexus);
    } else {
        initVexus();
    }
    
})();